<%@ page import="java.util.*, java.sql.*, java.util.ArrayList" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="ibase.utility.UserInfoBean, ibase.webitm.ejb.vhb.msq1.ApprovedRate" %>

<%
    System.out.println("@@@@@@@@ In ApprovedRate.jsp Khushal @@@@@@@@@@@@@@@@");
    UserInfoBean userInfo = (UserInfoBean) session.getAttribute("USER_INFO");

    if (userInfo == null) {
        out.print("<p style='color:red;'>Invalid session. Please log in.</p>");
        return;
    }

    String itemCode = request.getParameter("ITEM_CODE") != null ? request.getParameter("ITEM_CODE") : "";

    if (itemCode.trim().isEmpty()) {
        out.print("<p style='color:red;'>Item code is missing.</p>");
        return;
    }

    System.out.println("@@@@@@@@ ITEM_CODE: " + itemCode);
    HashMap<String, HashMap<String, ArrayList<String>>> approvedData = null;

    try {
        ApprovedRate approvedRate = new ApprovedRate(userInfo);
        approvedData = approvedRate.getLastThreeQuotationRates(itemCode);
        System.out.println("approvedData: " + approvedData);
    } catch (Exception e) {
        e.printStackTrace();
        out.print("<p style='color:red;'>Error retrieving approved quotation details: " + e.getMessage() + "</p>");
        return;
    }
    
    HashMap<String, ArrayList<String>> approvedMap = approvedData.get("quotationRatesMap");
    HashMap<String, ArrayList<String>> approvedMapMinMax = approvedData.get("quotationRatesMapmin");
%>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Approved Quotation Details</title>
    <link type="text/css" rel="stylesheet" href="/ibase/webitm/css/sidePanelDisplay.css">
</head>
<body>

<h2>Approved Quotation Details</h2>

<form>
    <table border="1" class="itemtbl">
        <tr>
            <th>Customer Code</th>
            <th>Customer Name</th>
            <th>Quotation No</th>
            <th>Quotation Date</th>
            <th>Item Code</th>
            <th>Item Description</th>
            <th>Approved Rate</th>
            <th>Quantity</th>
        </tr>
        <%
            if (approvedMap != null && !approvedMap.isEmpty()) {
                for (Map.Entry<String, ArrayList<String>> entry : approvedMap.entrySet()) {
                    ArrayList<String> values = entry.getValue();
        %>
        <tr>
            <% for (String value : values) { %>
                <td><%= value %></td>
            <% } %>
        </tr>
        <%
                }
            } else {
        %>
        <tr>
            <td colspan="8" style="color:red; text-align: center;">
                No approved quotations found for the selected item code.
            </td>
        </tr>
        <% } %>
    </table>

    <!-- Display Min and Max Rates -->
    <h3>Min and Max Approved Rates</h3>
    <table border="1" class="itemtbl">
        <tr>
            <th>Item Code</th>
            <th>Min Approved Rate</th>
            <th>Max Approved Rate</th>
        </tr>
        <%
            if (approvedMapMinMax != null && !approvedMapMinMax.isEmpty()) {
                for (Map.Entry<String, ArrayList<String>> entry : approvedMapMinMax.entrySet()) {
                    ArrayList<String> values = entry.getValue();
        %>
       <tr>
    <% for (String value : values) { %>
        <td><center><%= value %></center></td>
    <% } %>
      </tr> 
        <%
                }
            } else {
        %>
        <tr>
            <td colspan="3" style="color:red; text-align: center;">
                No min/max rates found for the selected item code.
            </td>
        </tr>
        <% } %>
    </table>

</form>

</body>
</html>
